export namespace LeaderboardConstants {
    export namespace FullLeaderboard {
        export const PRELOAD_ENTRY_COUNT = 20;
        export const ENTRY_SIZE_Y = 0.13;
        export const ENTRIES_LIMIT_TOP_POSITION_Y = 0.79;
        export const ENTRIES_NEEDED_FOR_SCROLL = 8;
        export const PARENT_HEADER_ANCHORS = Rect.create(-1, 1, -1.20, 0.8);
        export const PARENT_NO_HEADER_ANCHORS = Rect.create(-1, 1, -1, 1);

        export const HEADER_MASK_TOP_ANCHORS = Rect.create(-1, 1, ENTRIES_LIMIT_TOP_POSITION_Y, 1.1);
        export const NO_HEADER_MASK_TOP_ANCHORS = Rect.create(-1, 1, ENTRIES_LIMIT_TOP_POSITION_Y, 0.98);

        export const MIN_Y_COORD_TO_SHOW_ENTRY = -0.4;
        export const MAX_Y_COORD_TO_SHOW_ENTRY = 0.9;

        export const ENTRIES_BOTTOM_LIMIT_POSITION_HEADER = -0.1;
        export const ENTRIES_BOTTOM_LIMIT_POSITION_NO_HEADER = 0;
        export const ENTRIES_TOP_LIMIT_POSITION = ENTRIES_LIMIT_TOP_POSITION_Y - ENTRY_SIZE_Y / 2;

        export const ANIMATION_DURATION_MS = 400;
        export const CUSTOM_TEXTURE_START_RECT = Rect.create(-1, 1, -0.481, 1.00);
        export const CUSTOM_TEXTURE_END_RECT = Rect.create(-1, 1, -1, 1);

        export const CUSTOM_TEXTURE_PARENT_START_RECT = Rect.create(-1, 1, 0.3, 3);
        export const CUSTOM_TEXTURE_PARENT_END_RECT = Rect.create(-0.3, 0.3, 0.15, 0.8);

        export const TOP_BORDER_BOTTOM_START_VALUE = 1;
        export const TOP_BORDER_BOTTOM_END_VALUE = 2;
        export const ROUND_CORNER_SCALE_X_START_VALUE = 2;
        export const ROUND_CORNER_SCALE_X_END_VALUE = 1;

        export const TOUCH_COUNT_TO_CLOSE_VIEW = 2;

        export const INITIAL_PARENT_POSITION = new vec2(0, -2);

        export const DAILY_RESET_STRING = "Resets daily";
        export const WEEKLY_RESET_STRING = "Resets weekly";
        export const MONTHLY_RESET_STRING = "Resets monthly";
        export const YEARLY_RESET_STRING = "Resets yearly";
    }

    export namespace SingleBadge {
        export const POSITION =  new vec2(-0.70, -0.90);
        export const POSITION_OUT_OF_SCREEN =  new vec2(-3, -0.90);
        export const ANIMATION_DURATION_MS = 500;
    }

    export namespace InertialAnimation {
        export const MAX_SPEED = 4;
        export const FRICTION = 1.5;
        export const SNAP_DURATION = 0.3;
        export const SPRINGNESS = 1000;
    }

    export namespace Component {
        export const USER_LIMIT_FRIENDS = 50;
        export const USER_LIMIT_GLOBAL = 10;
    }

}
